/**
 * Created by Arvin on 2015-05-19.
 */
//全局2d画笔
var globalContext = null;
//页面右上角圆弧的背景色
var arcBgColor = "rgb(54, 100, 139)";
//页面背景色
var bgColor = "rgb(0, 0, 0)";
//验证标记--是否已经进行验证 true:正在进行验证;false:否
var verifyFlag = false;
//模式:1--1:1,2--1:N
var model = "2";
//定时器--验证
var verifyTimer = null;
var timer = null;

/**
 * 画椭圆 -- 给context添加绘画椭圆的属性
 * @author wenxin
 * @create 2013-05-15 10:11:21 am
 * @param x, y 椭圆定位的坐标
 * @param width, height 椭圆的宽度和高度
 */
CanvasRenderingContext2D.prototype.oval = function(x, y, width, height)
{
    var k = (width/0.75)/2,w = width/2,h = height/2;
    this.strokeStyle = bgColor;
    this.beginPath();

    this.moveTo(x, y-h);
    this.bezierCurveTo(x+k, y-h, x+k, y+h, x, y+h);
    this.bezierCurveTo(x-k, y+h, x-k, y-h, x, y-h);
    this.closePath();
    this.stroke();
    return this;
};

function showFPVerification(){
    var template = document.createElement('div');
    $(template).css({
        background: 'rgb(243, 245,240)'
    });
    var canvas = document.createElement('canvas');
    $(canvas).attr('id', 'canvas')
    $(canvas).attr('style', "background: url(\'/media/images/abroad_att/base_fpVerify.jpg\');");
    canvas.width = 450;
    canvas.height = 320;
    $(template).append(canvas);
    var options = {
        title: gettext("指纹登录验证"),
        skin: 'option_dialog',
        success: function(layero, index){
            if(verifyFlag){
                cancelCapture();
            }
            clearTimeout(timer);//将定时器的递归调用关闭
        }
    };
    $(template).layerDialog(options);
    //$(template).dialog({
    //    title:gettext("指纹登录验证"),
    //    on_load:function(obj){
    //        $("div.for_all#overlay").find("div#id_close").unbind().click(function(){
    //            if(verifyFlag){
    //                cancelCapture();
    //            }
    //            //将定时器的递归调用关闭
		//	    clearTimeout(timer);
		//		$(template).remove();
    //            $("div#overlay_target").overlay().close();
    //        });
    //    }
    //});
};
function clearImageData()
{
	//清空指纹图像
	clearFPImage(globalContext, "verification");
	//显示框--采集提示
	collectTips(globalContext, gettext("请水平按压手指验证"), "verification");
};
function fpComparison(fpTemplate){
    var post_url = "/accounts/login/";
	var redirect_url = "../../data/index/";
    if(fpTemplate){
        $("#id_template10").val(fpTemplate);
        var serialize_form = $("#login-form").serialize();
//        collectTips(globalContext, gettext("指纹比对中...."), "verification")
        $.ajax({
            url: post_url,
            type: 'POST',
            dataType: 'html',
            data: serialize_form,
            async: false,
            success: function (msg) {
                if (msg == 'error') {
                    collectTips(globalContext, gettext("验证失败，请重试!"), "verification");
                    setTimeout(function(){
                        clearImageData();
                        beginCapture(globalContext);
                    }, 1000);
                } else if (msg == "2") {
                    collectTips(globalContext, gettext("10.0指纹算法许可失败!"), "verification");
                    setTimeout(function(){
                        clearImageData();
                        beginCapture(globalContext);
                    }, 1000);
                } else {
                    collectTips(globalContext, gettext("验证通过，登录系统!"), "verification");
                    setTimeout(function(){
                        closeVerify();
                        window.location.href = redirect_url;
                    }, 1000);
                }
            }
        });
    }
    else{
        collectTips(globalContext, gettext("获取指纹失败，请重试!"), "verification")
        setTimeout(function(){
            clearImageData()
            beginCapture(globalContext);
        }, 1000);
    }
};
function checkColl(){
    var base64FPImg = "";
	//返回码
	var ret = null;
    var setting = {};
    setting.url = "/getImage?random="+getRandomNum();
    setting.async = false;
    setting.callback = function(result){
        //指纹采集次数
        var collCount = 0;
        ret = result.ret;
        if(ret == 0)
        {
            collCount = result.data.enroll_index;
            base64FPImg = result.data.jpg_base64;
        }
        if(collCount != 3)
        {
            //定时器
            timer = setTimeout(function(){
                checkColl();
            }, 1000);
        }
        else
        {
            //将定时器关闭
            clearTimeout(verifyTimer);
            //显示指纹图像
            showImage(globalContext, base64FPImg, "verification");
            //存放国际化元素数组
            //获取指纹模板
            getFPTemplate("verification");
        }
    }
    excute(setting);
};
/**
 * 开始采集
 */
function beginCapture(){
    var setting = {};
    setting.url = "/beginCapture?type=2&random="+getRandomNum();
    setting.async = true;
    setting.callback = function(result){
        //返回码
        var ret = null;
        ret = result.ret;
        //接口调用成功返回时
        if(ret == 0)
        {
            collectTips(globalContext, gettext("请水平按压手指验证"), "verification");
            verifyFlag = true;
            //检查采集、显示图像
            checkColl();
        }
        else if(ret == -2001)
        {
            //未检测到指纹采集器.:连接指纹采集器失败
            //显示框--采集提示
            collectTips(globalContext, gettext("未检测到指纹采集器."), "verification");
        }
        else if(ret == -2002)
        {
            getWebServerInfo(null, "1");
        }
        else if(ret == -2005)
        {
            //取消采集
            cancelCapture();
            //开始采集
            beginCapture(globalContext);
        }
    };
    excute(setting);
};
/**
 * 取消采集
 */
function cancelCapture(){
    var setting = {};
    setting.url = "/cancelCapture?random="+getRandomNum();
    setting.async = true;
    setting.callback = function(result){
        verifyFlag = false;
    }
    excute(setting);
}
/**
 * 关闭比对页面
 * @author wenxin
 * @create 2013-06-21 14:57:11 pm
 */
function closeVerify()
{
	closeWindow();
};
function showFPVerify(){
    canConnection = true;
    $("#fp_identify_disabled").hide();
	$("#id_fp_identify").show();
};
function fpLoginInit(){
    showFPVerification();
    var canvas = document.getElementById("canvas");
	var context = getCanvasContext(canvas);
	globalContext = context;
    collectTips(context, gettext("请水平按压手指验证"), "verification");
    //开始采集
	beginCapture(context);
    //定时器 5s后关闭验证界面
    verifyTimer = setTimeout(function(){
        closeVerify();
    }, 5000);
};
